using System;
using System.Collections;
using System.Configuration.Install;
using System.Collections.Specialized;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.ServiceProcess;
using System.Threading;
using System.Windows.Forms;
using NDI.SLIKDA.Interop;


namespace CSWindowsService
{
	public class Service1 : System.ServiceProcess.ServiceBase
	{
		/// <summary> 
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		private CServer m_ServerObject = null;

		public Service1()
		{
			// This call is required by the Windows.Forms Component Designer.
			InitializeComponent();

			// TODO: Add any initialization after the InitComponent call
		}

		// The main entry point for the process
		[STAThread]
		static void Main()
		{
			// Get the command line arguments to check for server registration switches
			string sCmdLine = System.Environment.CommandLine;

			//
			// Perform server registration as required.  This will only
			// register the executable as an OPC server.  It is expected
			// that InstallUtil.exe or installer services is / are used
			// to register the application as a Windows Service.
			//
			// NOTE: Case-sensitive comparison
			if( sCmdLine.IndexOf( "unregserver", 0) > 0 )
			{
				CServer svr = new CServer();
				svr.UnregisterServer();
				InstallAssembly( false );
				return;
			}
			else if( sCmdLine.IndexOf("regserver", 0) > 0 )
			{
				CServer svr = new CServer();
				InstallAssembly( true );
				svr.RegisterServer( "CSWindowsService" );
				return;
			}

			System.ServiceProcess.ServiceBase[] ServicesToRun;
	
			// More than one user Service may run within the same process. To add
			// another service to this process, change the following line to
			// create a second service object. For example,
			//
			//   ServicesToRun = New System.ServiceProcess.ServiceBase[] {new Service1(), new MySecondUserService()};
			//
			ServicesToRun = new System.ServiceProcess.ServiceBase[] { new Service1() };
			System.ServiceProcess.ServiceBase.Run(ServicesToRun);
		}

		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.ServiceName = "CSWindowsService";
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		private static bool InstallAssembly( bool bInstalling )
		{
			bool bRet = true;

			IDictionary mySavedState = new Hashtable();
			AssemblyInstaller myAssemblyInstaller = new AssemblyInstaller();
			try
			{
				// Set the properties to install the required assembly.
				myAssemblyInstaller.Path = Process.GetCurrentProcess().MainModule.FileName;
				myAssemblyInstaller.UseNewContext = true;

				// Clear the 'IDictionary' object.
				mySavedState.Clear();

				// Install the assembly.
				if( bInstalling )
					myAssemblyInstaller.Install( mySavedState );
				else
					myAssemblyInstaller.Uninstall( mySavedState );

				// Commit the install.
				myAssemblyInstaller.Commit( mySavedState );
			}
			catch( Exception e )
			{
				string sErr = e.Message;
				bRet = false;
			}

			return bRet;
		}

		/// <summary>
		/// Set things in motion so your service can do its work.
		/// </summary>
		protected override void OnStart(string[] args)
		{
			// TODO: Add code here to start your service.
			m_ServerObject = new CServer();
			m_ServerObject.StartServer();
		}
 
		/// <summary>
		/// Stop this service.
		/// </summary>
		protected override void OnStop()
		{
			// TODO: Add code here to perform any tear-down necessary to stop your service.
			if( m_ServerObject != null )
				m_ServerObject.StopServer();
		}
	}
}
